/* converted from ElSami's Superscale filter */

typedef unsigned char bool8;
typedef unsigned char uint8;
typedef unsigned short uint16;
typedef signed char int8;
typedef short int16;
typedef long int32;
typedef unsigned int uint32;

extern "C" void __cdecl superscale_line(uint16 *src0, uint16 *src1, uint16 *src2, uint16 *dst, uint32 width);
extern "C" void __cdecl superscale_line_75(uint16 *src0, uint16 *src1, uint16 *src2, uint16 *dst, uint32 width, const unsigned __int64 *mask);

static const unsigned __int64 mask = 0x7BEF7BEF7BEF7BEF;

void SuperScale(unsigned short *src,unsigned int srcpitch,unsigned short *dst,unsigned int dstpitch,unsigned short width,unsigned short height)
{
	unsigned short *dst0=dst;
    unsigned short *dst1=dst+dstpitch/2;
    unsigned short *src0=src-srcpitch;  //don't worry, there is extra space :)
    unsigned short *src1=src+0;
    unsigned short *src2=src+srcpitch;
    int i;
    for(i=0;i<height;++i)
    {
        superscale_line(src0,src1,src2,dst0,width);
        superscale_line(src2,src1,src0,dst1,width);
        src0=src1;
        src1=src2;
        src2+=srcpitch;
        dst0+=dstpitch;
        dst1+=dstpitch;
    }
	__asm { //("emms");
		emms
	}
}


void SuperScale75(unsigned short *src,unsigned int srcpitch,unsigned short *dst,unsigned int dstpitch,unsigned short width,unsigned short height)
{
    unsigned short *dst0=dst;
    unsigned short *dst1=dst+dstpitch/2;
    unsigned short *src0=src-srcpitch;  //don't worry, there is extra space :)
    unsigned short *src1=src+0;
    unsigned short *src2=src+srcpitch;
    int i;
    for(i=0;i<height;++i)
    {
        superscale_line(src0,src1,src2,dst0,width);
        superscale_line_75(src2,src1,src0,dst1,width,&mask);
        src0=src1;
        src1=src2;
        src2+=srcpitch;
        dst0+=dstpitch;
        dst1+=dstpitch;
    }
    __asm { //("emms");
		emms
	}
}